'ASM Bezier second source
PltInit:
'Has to be called once before plotting.
'  LD C,PINIT
'  CALL PRT
'  LD C,PGETMOD
'  CALL PRT
'  CP 01
'  LD A,27 'ErrCode
'  LD C,PGRAPH
'  CALL PRT
  RET
PltSeg:
'Plots a Bezier segment.
'HL=Start address of segment (x4)
'REG: BC,HL,DE
  INC HL
  INC HL
  INC HL 'end of P4
  LD DE,c3+3 'end of c3
  LD BC,4
  LDDR 'copy P4 to c3
  LD BC,16
  ADD HL,BC 'end of P1234
  LD BC,4
  LDDR 'copy P1234 to c2
  LD BC,16
  ADD HL,BC 'end of P1
  LD BC,4
  LDDR 'copy P1 to c1mul

  LD IX,c1
  LD B,3
  CALL Fix2int
  LD HL,c1
  LD B,3
  LD C,PAMVDN
  CALL PRT
  RET
Fix2int:
'Convert 13.2 fix point coordinates
'to integer coordinates by rounding.
'IX=Address of the first point.
'B=Number of coordinates.
  PUSH BC
  LD A,B
  ADD A,B 'number of points
convNum:
  LD L,(IX+0)
  LD H,(IX+1)
  LD BC,2
  ADD HL,BC 'round up: HL+2
  SRA H
  RR L
  SRA H
  RR L
  LD (IX+0),L
  LD (IX+1),H
  INC IX
  INC IX
  DEC A
  JR NZ,convNum
  POP BC
  RET
PosHL:
'Make HL positive
  XOR A
  SUB A,L
  LD L,A
  SBC A,A
  SUB A,H
  LD H,A
  RET
PRT:
  RST &20
  DEFB 4
  DEFW PRTIOCS
  RET
PCHEK:
  LD A,(&F9EF)
'  RST &20
'  DEFB 4
'  DEFW &4020
  AND &A1
  CP &81
  RET Z
  LD A,28
  SCF
  RET
ENDPRT:
  LD C,PPENUP
  XOR A  'pen up
  CALL PRT
  RST &20
  DEFB 4
  DEFW &4029
  RST &20
  DEFB 4
  DEFW &6777
  RET
'Space for plotter lines coordinates:
c1:
  DEFW 0 'p1.x
  DEFW 0 'p1.y
c2:
  DEFW 0 'p2.x
  DEFW 0 'p2.y
c3:
  DEFW 0 'p3.x
  DEFW 0 'p3.y
c4:
  DEFW 0
  DEFW 0
c5:
  DEFW 0
  DEFW 0
c6:
  DEFW 0
  DEFW 0
'Space for initial Bezier
'points coordinates:
P1x: 'start point
  DEFW 150 'P1.x
P1y:
  DEFW 440 'P1.y
P2x: control point 1
  DEFW 450 'P2.x
P2y:
  DEFW 10 'P2.y
P3x: 'control point 2
  DEFW 50 'P3.x
P3y:
  DEFW 10 'P3.y
P4x: 'end point
  DEFW 25 'P4.x
P4y:
  DEFW 45 'P4.y

'Space for Bzier subdivision
'coordinates. This area grows
'in size, so has to be at the
'very end.
Idx:
  DEFW 0
Level:
  DEFW 0
FlatFlag:
  DEFW 0
DirFlags:
  DEFW 0
X4:
x4:
  DEFW 280
Y4:
y4:
  DEFW -65
X3:
x34:
  DEFW 170
Y3:
y34:
  DEFW 135
X2:
x234:
  DEFW 20
Y2:
y234:
  DEFW 40
X1:
x1234:
  DEFW 5
Y1:
y1234:
  DEFW 3
x123:
  DEFW 0
y123:
  DEFW 0
x12:
  DEFW 0
y12:
  DEFW 0
x1:
  DEFW 0
y1:
  DEFW 0
END
'END OF FILE BEZIER2.ASM

